-- Généré le : Mar 04 Mai 2010 à 10:39
-- Version du serveur: 5.1.30
-- Version de PHP: 5.3.2
--
-- Base de données: `lilas`
-- Structure de la table `activite`
CREATE TABLE IF NOT EXISTS `activite` (
  `N_ACTIVITE` int(11) NOT NULL,
  `NOM_ACTIVITE` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`N_ACTIVITE`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;

-- Structure de la table `animateur`
CREATE TABLE IF NOT EXISTS `animateur` (
  `N_ANIMATEUR` int(11) NOT NULL,
  `NOM_ANIMATEUR` varchar(15) DEFAULT NULL,
  `PRENOM_ANIMATEUR` varchar(15) DEFAULT NULL,
  `DIPLOME` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`N_ANIMATEUR`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;

-- Structure de la table `capacite`
CREATE TABLE IF NOT EXISTS `capacite` (
  `CODE_AGE` int(11) NOT NULL,
  `N_ACTIVITE` int(11) NOT NULL,
  `N_SEMAINE` int(11) NOT NULL,
  `NB_ENFANTS_MAX` int(11) DEFAULT NULL,
  PRIMARY KEY (`CODE_AGE`,`N_ACTIVITE`,`N_SEMAINE`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;

-- Structure de la table `categorie`
CREATE TABLE IF NOT EXISTS `categorie` (
  `CODE_AGE` int(11) NOT NULL,
  `NOM_CATEGORIE` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`CODE_AGE`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;

-- Structure de la table `competent`
CREATE TABLE IF NOT EXISTS `competent` (
  `N_ANIMATEUR` int(11) NOT NULL,
  `N_ACTIVITE` int(11) NOT NULL,
  PRIMARY KEY (`N_ANIMATEUR`,`N_ACTIVITE`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;

-- Structure de la table `encadrer`
CREATE TABLE IF NOT EXISTS `encadrer` (
  `N_ANIMATEUR` int(11) NOT NULL,
  `JOUR` char(10) NOT NULL,
  PRIMARY KEY (`N_ANIMATEUR`,`JOUR`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;

-- Structure de la table `enfant`
CREATE TABLE IF NOT EXISTS `enfant` (
  `N_ENFANT` int(11) NOT NULL,
  `CODE_AGE` int(11) NOT NULL,
  `NOM_ENFANT` varchar(15) DEFAULT NULL,
  `PRENOM_ENFANT` varchar(15) DEFAULT NULL,
  `DATE_DE_NAISSANCE` date DEFAULT NULL,
  PRIMARY KEY (`N_ENFANT`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;

-- Structure de la table `inscrire`
CREATE TABLE IF NOT EXISTS `inscrire` (
  `N_ENFANT` int(11) NOT NULL,
  `N_SEMAINE` int(11) NOT NULL,
  PRIMARY KEY (`N_ENFANT`,`N_SEMAINE`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;

-- Structure de la table `jour`
CREATE TABLE IF NOT EXISTS `jour` (
  `JOUR` char(10) NOT NULL,
  `N_SEMAINE` int(11) NOT NULL,
  PRIMARY KEY (`JOUR`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;

-- Structure de la table `planning`
CREATE TABLE IF NOT EXISTS `planning` (
  `N_ANIMATEUR` int(11) NOT NULL,
  `N_SEMAINE` int(11) NOT NULL,
  PRIMARY KEY (`N_ANIMATEUR`,`N_SEMAINE`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;

-- Structure de la table `semaine`
CREATE TABLE IF NOT EXISTS `semaine` (
  `N_SEMAINE` int(11) NOT NULL,
  `LIBELLE_SEMAINE` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`N_SEMAINE`)
) TYPE=InnoDB DEFAULT CHARSET=latin1;
-- Contraintes pour les tables exportées
-- Contraintes pour la table `capacite`

ALTER TABLE `capacite`
  ADD CONSTRAINT `capacite_ibfk_1` FOREIGN KEY (`CODE_AGE`) REFERENCES `categorie` (`CODE_AGE`),
  ADD CONSTRAINT `capacite_ibfk_2` FOREIGN KEY (`N_ACTIVITE`) REFERENCES `activite` (`N_ACTIVITE`),
  ADD CONSTRAINT `capacite_ibfk_3` FOREIGN KEY (`N_SEMAINE`) REFERENCES `semaine` (`N_SEMAINE`);

 -- Contraintes pour la table `competent`
ALTER TABLE `competent`
  ADD CONSTRAINT `competent_ibfk_1` FOREIGN KEY (`N_ANIMATEUR`) REFERENCES `animateur` (`N_ANIMATEUR`),
  ADD CONSTRAINT `competent_ibfk_2` FOREIGN KEY (`N_ACTIVITE`) REFERENCES `activite` (`N_ACTIVITE`);

-- Contraintes pour la table `encadrer`
ALTER TABLE `encadrer`
  ADD CONSTRAINT `encadrer_ibfk_1` FOREIGN KEY (`N_ANIMATEUR`) REFERENCES `animateur` (`N_ANIMATEUR`),
  ADD CONSTRAINT `encadrer_ibfk_2` FOREIGN KEY (`JOUR`) REFERENCES `jour` (`JOUR`);

-- Contraintes pour la table `enfant`
ALTER TABLE `enfant`
  ADD CONSTRAINT `enfant_ibfk_1` FOREIGN KEY (`CODE_AGE`) REFERENCES `categorie` (`CODE_AGE`);

-- Contraintes pour la table `inscrire`
ALTER TABLE `inscrire`
  ADD CONSTRAINT `inscrire_ibfk_1` FOREIGN KEY (`N_ENFANT`) REFERENCES `enfant` (`N_ENFANT`),
  ADD CONSTRAINT `inscrire_ibfk_2` FOREIGN KEY (`N_SEMAINE`) REFERENCES `semaine` (`N_SEMAINE`);

-- Contraintes pour la table `jour`
ALTER TABLE `jour`
  ADD CONSTRAINT `jour_ibfk_1` FOREIGN KEY (`N_SEMAINE`) REFERENCES `semaine` (`N_SEMAINE`);

-- Contraintes pour la table `planning`
ALTER TABLE `planning`
  ADD CONSTRAINT `planning_ibfk_1` FOREIGN KEY (`N_ANIMATEUR`) REFERENCES `animateur` (`N_ANIMATEUR`),
  ADD CONSTRAINT `planning_ibfk_2` FOREIGN KEY (`N_SEMAINE`) REFERENCES `semaine` (`N_SEMAINE`);
